(function ($) {
    'use strict';

    window.weelsGenerate = function (orderId) {
        var $btn = $('#weels-gen-btn');
        var $result = $('#weels-result');

        $btn.prop('disabled', true).text('Generating...');
        $result.html('<span style="color:#666;">Creating shipment...</span>');

        $.post(weelsAdmin.ajaxUrl, {
            action: 'weels_generate_label',
            nonce: weelsAdmin.nonce,
            order_id: orderId
        }, function (response) {
            if (response.success) {
                var d = response.data;
                $result.html(
                    '<span class="weels-success">Label generated!</span><br>' +
                    '<a href="' + d.label_url + '" target="_blank">View Label</a> | ' +
                    '<a href="' + d.tracking_url + '" target="_blank">Track</a>'
                );
                setTimeout(function () { location.reload(); }, 1500);
            } else {
                $result.html('<span class="weels-error">' + (response.data.message || response.data.error || 'Failed') + '</span>');
                $btn.prop('disabled', false).text('Retry');
            }
        }).fail(function () {
            $result.html('<span class="weels-error">Request failed. Try again.</span>');
            $btn.prop('disabled', false).text('Retry');
        });
    };

    window.weelsVoid = function (orderId) {
        if (!confirm('Void this shipment? The label will be cancelled.')) return;

        var $result = $('#weels-result');
        $result.html('<span style="color:#666;">Voiding...</span>');

        $.post(weelsAdmin.ajaxUrl, {
            action: 'weels_void_label',
            nonce: weelsAdmin.nonce,
            order_id: orderId
        }, function (response) {
            if (response.success) {
                $result.html('<span class="weels-success">Shipment voided.</span>');
                setTimeout(function () { location.reload(); }, 1000);
            } else {
                $result.html('<span class="weels-error">' + (response.data.message || 'Failed to void') + '</span>');
            }
        }).fail(function () {
            $result.html('<span class="weels-error">Request failed. Try again.</span>');
        });
    };

})(jQuery);
